class RPGMutator extends Mutator config(MSRPG);

var string SummonClass;
var Config class<actor> ApprovedClasses[100];
var PlayerPawn Suspended[20];
var Config bool bAllowSummoning;

function PostBeginPlay()
{   
	Level.Game.BaseMutator.AddMutator(Self);
	Level.Game.RegisterDamageMutator(Self);
}

function SummonShit(PlayerPawn Player, String SummonClass)
{
       local class<actor> ShitToSummon;
       local int j;

       j = InStr(SummonClass, ".");
       if (j == -1)
         SummonClass = "DeusEx." $ SummonClass;
       log( "Fabricate " $ SummonClass );
       ShitToSummon = class<actor>( DynamicLoadObject( SummonClass, class'Class' ) );
	if (ShitToSummon != None)
        {
         if (bShouldSpawn(ShitToSummon))
         {
		// DEUS_EX STM
		//Spawn( NewClass,,,Location + 72 * Vector(Rotation) + vect(0,0,1) * 15 );
		Spawn( ShitToSummon,Player,,Player.Location + (Player.CollisionRadius+ShitToSummon.Default.CollisionRadius+30) * Vector(Player.Rotation) + vect(0,0,1) * 15 );
                BroadcastMessage("|p7"$Player.PlayerReplicationInfo.PlayerName$"|p3 summoned a "$ShitToSummon$".");
         }
         else
          Player.ClientMessage("|p2ERROR: Class |p4"$SummonClass$"|p2 is not allowed!");

        }
        else
         Player.ClientMessage("|p2ERROR: Cannot Find Actor |p4"$SummonClass$"!");
}

simulated function bool bInList(PlayerPawn P)
{
	local int i;

		for (i=0;i<ArrayCount(Suspended);i++)
			if (Suspended[i] == P)
				return True;
	return False;
}

simulated function bool bShouldSpawn(class<actor> ActorName)
{
	local int i;

	for (i=0;i<ArrayCount(ApprovedClasses);i++)
			if ((ApprovedClasses[i] == ActorName) || (ClassIsChildOf(ActorName, ApprovedClasses[i])))
				return True;

	return False;
}

function SummonBan(PlayerPawn Player)
{
	local Actor           hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
        local int i;

	position    = Player.Location;
	position.Z += Player.BaseEyeHeight;
	line        = Vector(Player.ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position+line, position, true);
	if (hitActor != None)
	{
          if (hitActor.IsA('PlayerPawn'))
          {
		for (i=0;i<ArrayCount(Suspended);i++) // not sure which of these is their definition of blank so ill just accept any...
			if ((Suspended[i] == None) && (!bInList(PlayerPawn(hitActor))))
                        {
				Suspended[i] = PlayerPawn(hitActor);
                                PlayerPawn(HitActor).ClientMessage("|p2You have just been banned from summoning.");
                                Player.ClientMessage("|p2"$PlayerPawn(hitActor).PlayerReplicationInfo.PlayerName$" is now banned from summoning.");
                                break;                  
                        }
                        else
                        {
                         Player.ClientMessage("|p2ERROR: Either Player is Already Banned or Ban List Is Full.");
                         return;
                        }
          }
        }
}

function DeleteShit(PlayerPawn Player)
{
	local Actor           hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;

	position    = Player.Location;
	position.Z += Player.BaseEyeHeight;
	line        = Vector(Player.ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position+line, position, true);
	if (hitActor != None)
	{
         if (!hitActor.IsA('Brush'))
         {
          if (!hitActor.IsA('PlayerPawn'))
          {
           if (!Player.bAdmin)
           {
            if (hitActor.Owner == Player)
            {
             Player.ClientMessage("|p3"$hitActor.Class$" has been deleted, thank you for cleaning up :D");
             hitActor.Destroy();
             return;
            }
            else
             Player.ClientMessage("|p2ERROR: Actor does not belong to you.");
           }
           if (Player.bAdmin)
           {
             Player.ClientMessage("|p2"$hitActor.Class$" has been deleted, thank you for cleaning up :D");
             hitActor.Destroy();
             return;
           }
          }
         else
          Player.ClientMessage("|p2ERROR: Cannot delete players.");
         }
        }
}

function Mutate(string S, PlayerPawn Player)
{
	local Pawn P;
	local String str, cmd;
	local int j, i;
        local DeusExPlayer DXP;

	j = InStr(S, " ");

        cmd = Left(S, j);
          if (cmd ~= "Summon")
          {
           if (bAllowSummoning)
           {
            if (!bInList(Player))
            {
//	     i = InStr(S, " ");
//           if (i > -1)
//           {
//            i = i - j;
              SummonClass = Mid(S, j + 1);
              SummonShit(Player, SummonClass);
//           }
/*           if (i == -1)
             {
              Player.ClientMessage("|p2ERROR: Proper format is mutate summon,(class) and then a space(no space after comma).");
              return;
             }*/
            }
            else
            {
             Player.ClientMessage("|p2ERROR: You are currently banned from RPG summoning.");
             return;
            }
           } 
           else
           {
            Player.ClientMessage("|p2ERROR: This command is currently disabled.");
            return;
           }
          }
          if (S ~= "SummonBan")
          {
           if (Player.bAdmin)
           {
            SummonBan(Player);
           } 
           else
           {
            Player.ClientMessage("|p2This command is for admins only.");
            return;
           }
          }
          if (S ~= "Delete")
          {
           DeleteShit(Player);
          }
Super.Mutate(S, Player);
}

function MutatorTakeDamage(out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
		if ((Victim.Region.Zone.IsA('ZoneInfo')) && (Victim.Region.Zone.bNeutralZone) || (InstigatedBy.Region.Zone.bNeutralZone))
		{
			ActualDamage = 0;
                        InstigatedBy.ClientMessage("|p2THIS IS A NO KILLING ZONE!");
		}
	Super.MutatorTakeDamage(ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);
}

defaultproperties
{
ApprovedClasses(0)=DeusEx.Hooker1
ApprovedClasses(1)=DeusEx.Hooker2
ApprovedClasses(2)=DeusEx.Mutt
ApprovedClasses(3)=DeusEx.Doberman
ApprovedClasses(4)=DeusEx.Cat
ApprovedClasses(5)=DeusEx.KarkianBaby
ApprovedClasses(6)=DeusEx.Greasel
ApprovedClasses(7)=DeusEx.Female4
ApprovedClasses(8)=DeusEx.CoffeeTable
ApprovedClasses(9)=DeusEx.Cushion
ApprovedClasses(10)=DeusEx.Lamp1
ApprovedClasses(11)=DeusEx.Lamp2
ApprovedClasses(12)=DeusEx.Lamp3
ApprovedClasses(13)=DeusEx.Chair1
ApprovedClasses(14)=DeusEx.ChairLeather
ApprovedClasses(15)=DeusEx.CouchLeather
ApprovedClasses(16)=DeusEx.HKChair
ApprovedClasses(17)=DeusEx.HKCouch
ApprovedClasses(18)=DeusEx.OfficeChair
ApprovedClasses(19)=DeusEx.WHBenchEast
ApprovedClasses(20)=DeusEx.WHBenchLibrary
ApprovedClasses(21)=DeusEx.WHChairDining
ApprovedClasses(22)=DeusEx.WHChairOvalOffice
ApprovedClasses(23)=DeusEx.WHChairPink
ApprovedClasses(24)=DeusEx.WHRedCouch
ApprovedClasses(25)=DeusEx.AlarmLight
ApprovedClasses(26)=DeusEx.Basketball
ApprovedClasses(27)=DeusEx.BoneFemur
ApprovedClasses(28)=DeusEx.BoneSkull
ApprovedClasses(29)=DeusEx.Cart
ApprovedClasses(30)=DeusEx.CrateUnbreakableSmall
ApprovedClasses(31)=DeusEx.FlagPole
ApprovedClasses(32)=DeusEx.Flask
ApprovedClasses(33)=DeusEx.Flowers
ApprovedClasses(34)=DeusEx.ClothesRack
ApprovedClasses(35)=DeusEx.HKTable
ApprovedClasses(36)=DeusEx.HKMarketTable
ApprovedClasses(37)=DeusEx.HKIncenseBurner
ApprovedClasses(38)=DeusEx.HKBuddha
ApprovedClasses(39)=DeusEx.BookClosed
ApprovedClasses(40)=DeusEx.BookOpen
ApprovedClasses(41)=DeusEx.NewsPaper
ApprovedClasses(42)=DeusEx.NewspaperOpen
ApprovedClasses(43)=DeusEx.MicroScope
ApprovedClasses(44)=DeusEx.Pan1
ApprovedClasses(45)=DeusEx.Pan2
ApprovedClasses(46)=DeusEx.Pan3
ApprovedClasses(47)=DeusEx.Pan4
ApprovedClasses(48)=DeusEx.Pillow
ApprovedClasses(49)=DeusEx.Plant1
ApprovedClasses(50)=DeusEx.Plant2
ApprovedClasses(51)=DeusEx.Plant3
ApprovedClasses(52)=DeusEx.Pot1
ApprovedClasses(53)=DeusEx.Pot2
ApprovedClasses(54)=DeusEx.SignFloor
ApprovedClasses(55)=DeusEx.Toilet
ApprovedClasses(56)=DeusEx.Toilet2
ApprovedClasses(57)=DeusEx.Trophy
ApprovedClasses(58)=DeusEx.Vase1
ApprovedClasses(59)=DeusEx.Vase2
ApprovedClasses(60)=DeusEx.WaterCooler
ApprovedClasses(61)=DeusEx.WaterFountain
ApprovedClasses(62)=DeusEx.Containers
ApprovedClasses(63)=DeusEx.WashingtonDecoration
ApprovedClasses(64)=DeusEx.Pinball
ApprovedClasses(65)=DeusEx.Phone
ApprovedClasses(66)=DeusEx.TAD
bAllowSummoning=True
}